package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * po_sys_doc_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum PoSysDocType {

    STANDARD("standard", "标准订单"),
    RETURN("return", "退货订单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PoSysDocType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PoSysDocType fromCode(String code) {
        return Stream.of(PoSysDocType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
