package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * retry_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum RetryType {

    _1("1", "节点自动重试"),
    _2("2", "人工调度");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RetryType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RetryType fromCode(String code) {
        return Stream.of(RetryType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
