package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * salesorg_code
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum SalesorgCode {

    SDS1("SDS1", "营销总公司"),
    SDSO("SDSO", "上海分公司"),
    CCSO("CCSO", "长春分公司"),
    DASO("DASO", "哈尔滨分公司"),
    DBSO("DBSO", "沈阳分公司"),
    DCSO("DCSO", "北京分公司");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SalesorgCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesorgCode fromCode(String code) {
        return Stream.of(SalesorgCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
