package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_offset_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public enum SellerOffsetStatus {

    UNMATCH("unmatch", "未匹配"),
    MATCHING("matching", "匹配中"),
    TO_BE_CONFIRMED("toBeConfirmed", "待确认"),
    CONFIRMED("confirmed", "已确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SellerOffsetStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerOffsetStatus fromCode(String code) {
        return Stream.of(SellerOffsetStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
