package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * billing_no_invoice_record
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingNoInvoiceRecord implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * billing单编号
   */
  private String billingNo;
  /**
   * billing单头表奥特曼id
   */
  private String billingHeaderId;
  /**
   * 操作时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime operationTime;
  /**
   * 操作人账号
   */
  private String userAccount;
  /**
   * 操作人姓名
   */
  private String userName;
  /**
   * 操作来源
   */
  private String sourceFrom;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 操作后不开票标识描述
   */
  private String afterNoInvoiceStatusDesc;
  /**
   * 操作后不开票原因值
   */
  private String afterNoInvoiceReason;
  /**
   * 操作后不开票原因描述
   */
  private String afterNoInvoiceReasonDesc;
  /**
   * 操作前不开票原因描述
   */
  private String beforeNoInvoiceReasonDesc;
  /**
   * 操作后不开票标识值
   */
  private String afterNoInvoiceStatus;
  /**
   * 操作前不开票标识描述
   */
  private String beforeNoInvoiceStatusDesc;
  /**
   * 操作前不开票标识值
   */
  private String beforeNoInvoiceStatus;
  /**
   * 操作前不开票原因值
   */
  private String beforeNoInvoiceReason;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("billingNo", billingNo);
      map.put("billingHeaderId", billingHeaderId);
      map.put("operationTime", BocpGenUtils.toTimestamp(operationTime));
      map.put("userAccount", userAccount);
      map.put("userName", userName);
      map.put("sourceFrom", sourceFrom);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("afterNoInvoiceStatusDesc", afterNoInvoiceStatusDesc);
      map.put("afterNoInvoiceReason", afterNoInvoiceReason);
      map.put("afterNoInvoiceReasonDesc", afterNoInvoiceReasonDesc);
      map.put("beforeNoInvoiceReasonDesc", beforeNoInvoiceReasonDesc);
      map.put("afterNoInvoiceStatus", afterNoInvoiceStatus);
      map.put("beforeNoInvoiceStatusDesc", beforeNoInvoiceStatusDesc);
      map.put("beforeNoInvoiceStatus", beforeNoInvoiceStatus);
      map.put("beforeNoInvoiceReason", beforeNoInvoiceReason);

      return map;
  }

  public static BillingNoInvoiceRecord fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingNoInvoiceRecord entity = new BillingNoInvoiceRecord();

    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingHeaderId")) {
      Object obj = map.get("billingHeaderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillingHeaderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operationTime")) {
      Object obj = map.get("operationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOperationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOperationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOperationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOperationTime(null);
      }
    }
    if(map.containsKey("userAccount")) {
      Object obj = map.get("userAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceFrom")) {
      Object obj = map.get("sourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceStatusDesc")) {
      Object obj = map.get("afterNoInvoiceStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterNoInvoiceStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceReason")) {
      Object obj = map.get("afterNoInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterNoInvoiceReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceReasonDesc")) {
      Object obj = map.get("afterNoInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceReasonDesc")) {
      Object obj = map.get("beforeNoInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeforeNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceStatus")) {
      Object obj = map.get("afterNoInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceStatusDesc")) {
      Object obj = map.get("beforeNoInvoiceStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeforeNoInvoiceStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceStatus")) {
      Object obj = map.get("beforeNoInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeforeNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceReason")) {
      Object obj = map.get("beforeNoInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeforeNoInvoiceReason((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("billingNo")) {
      Object obj = map.get("billingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingHeaderId")) {
      Object obj = map.get("billingHeaderId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillingHeaderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operationTime")) {
      Object obj = map.get("operationTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOperationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOperationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOperationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOperationTime(null);
      }
    }
    if(map.containsKey("userAccount")) {
      Object obj = map.get("userAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceFrom")) {
      Object obj = map.get("sourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceStatusDesc")) {
      Object obj = map.get("afterNoInvoiceStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAfterNoInvoiceStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceReason")) {
      Object obj = map.get("afterNoInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAfterNoInvoiceReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceReasonDesc")) {
      Object obj = map.get("afterNoInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAfterNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceReasonDesc")) {
      Object obj = map.get("beforeNoInvoiceReasonDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBeforeNoInvoiceReasonDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("afterNoInvoiceStatus")) {
      Object obj = map.get("afterNoInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAfterNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceStatusDesc")) {
      Object obj = map.get("beforeNoInvoiceStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBeforeNoInvoiceStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceStatus")) {
      Object obj = map.get("beforeNoInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBeforeNoInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beforeNoInvoiceReason")) {
      Object obj = map.get("beforeNoInvoiceReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBeforeNoInvoiceReason((String)obj);
        }
      } else{
      }
    }
  }
}
