package com.xforceplus.ultraman.app.arterydocument.metadata.validator;

import com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.arterydocument.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-07-25
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PSourceFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PSourceFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerClearingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerClearingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerClearingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerOffsetStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerOffsetStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerOffsetStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementSourceFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementSourceFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceReasonDesc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoInvoiceReasonDesc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoInvoiceReasonDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WriteOffType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WriteOffType.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WriteOffStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WriteOffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingRefSettlementBindingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingRefSettlementBindingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingRefSettlementBindingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedInvoiceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedInvoiceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(TransferStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TransferStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentType.class.getSimpleName());
            }
        }
        if(clazz.equals(PageElementName.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PageElementName.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PageElementName.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpenseDetailSourceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExpenseDetailSourceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExpenseDetailSourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpTransmitStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErpTransmitStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErpTransmitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessTagLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessTagLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessTagLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(SupportStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SupportStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SupportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CaptureMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CaptureMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CaptureMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(PosApprovalStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PosApprovalStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PosApprovalStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BatchTransferStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BatchTransferStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BatchTransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataIssueStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataIssueStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataIssueStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StatisticalType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StatisticalType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StatisticalType.class.getSimpleName());
            }
        }
        if(clazz.equals(CaptureType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CaptureType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CaptureType.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActiveStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConversionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WarningStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WarningStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WarningStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SendFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SendFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SendFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SuitType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SuitType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SuitType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionIgnoreReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExceptionIgnoreReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExceptionIgnoreReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpCallbackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErpCallbackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErpCallbackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PoSysDocType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PoSysDocType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PoSysDocType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderGoodsManageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderGoodsManageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderGoodsManageType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsType.class.getSimpleName());
            }
        }
        if(clazz.equals(PosDateSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PosDateSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PosDateSource.class.getSimpleName());
            }
        }
        if(clazz.equals(PNoConversionFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PNoConversionFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PNoConversionFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PDistributeFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PDistributeFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PDistributeFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DocTransferState.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocTransferState.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocTransferState.class.getSimpleName());
            }
        }
        if(clazz.equals(AppendStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AppendStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AppendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LinereservationDeliveryNoteStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LinereservationDeliveryNoteStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LinereservationDeliveryNoteStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExecutionTaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExecutionTaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExecutionTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EnumTaskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnumTaskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnumTaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnumBusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnumBusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnumBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplicationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplicationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplicationType.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaseRetailer.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PurchaseRetailer.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PurchaseRetailer.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProcessingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProcessingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplicationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplicationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplicationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesorgCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SalesorgCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SalesorgCode.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingSourceFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingSourceFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountActivationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountActivationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountActivationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountRunningStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountRunningStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountRunningStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountSecretKeyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountSecretKeyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountSecretKeyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetryType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetryType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetryType.class.getSimpleName());
            }
        }
        if(clazz.equals(RetryTaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetryTaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetryTaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HuaweicloudPoStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HuaweicloudPoStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HuaweicloudPoStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentPool.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentPool.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentPool.class.getSimpleName());
            }
        }
        if(clazz.equals(SendControlStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SendControlStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SendControlStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
