package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * append_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum AppendStatus {

    _0("0", "待补录"),
    _1("1", "已补录"),
    _2("2", "无需补录");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AppendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AppendStatus fromCode(String code) {
        return Stream.of(AppendStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
