package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * enum_task_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum EnumTaskType {

    _0("0", "RPA网站取数"),
    _1("1", "RPA网站回写"),
    _2("2", "RPA网站回写取消"),
    _3("3", "RPA网站回写修改");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnumTaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EnumTaskType fromCode(String code) {
        return Stream.of(EnumTaskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
