package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * expense_detail_source_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum ExpenseDetailSourceType {

    EXPENSE_SETTLEMENT_DETAIL("expenseSettlementDetail", "费用单"),
    SETTLEMENT_BILL("settlementBill", "结算单"),
    PAYMENT("payment", "付款单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExpenseDetailSourceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExpenseDetailSourceType fromCode(String code) {
        return Stream.of(ExpenseDetailSourceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
