package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * huaweicloud_po_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum HuaweicloudPoStatus {

    NEW("new", "待生效"),
    EFFECTIVE("effective", "生效中"),
    EXPIRING_SOON("expiringSoon", "快过期"),
    EXPIRED("expired", "已过期");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HuaweicloudPoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HuaweicloudPoStatus fromCode(String code) {
        return Stream.of(HuaweicloudPoStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
