package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_return_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum InvoiceReturnStatus {

    TO_BE_SELECTED("toBeSelected", "待勾选"),
    TO_BE_EXECUTED("toBeExecuted", "待执行"),
    FAIL("fail", "执行失败"),
    SUCCESS("success", "执行成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceReturnStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceReturnStatus fromCode(String code) {
        return Stream.of(InvoiceReturnStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
