package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pos_date_source
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum PosDateSource {

    数据采集("数据采集", "数据采集"),
    数据导入("数据导入", "导入补录"),
    销方创建("销方创建", "自动补录");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PosDateSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PosDateSource fromCode(String code) {
        return Stream.of(PosDateSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
