package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * purchase_retailer
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum PurchaseRetailer {

    CRV("crv", "华润万家"),
    CRV_O_L_E("crvOLE", "华润OLE"),
    RTMART("rtmart", "大润发"),
    YONGHUI("yonghui", "永辉"),
    SUGUO("suguo", "华润苏果"),
    JIAJIAYUE("jiajiayue", "家家悦");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PurchaseRetailer(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurchaseRetailer fromCode(String code) {
        return Stream.of(PurchaseRetailer.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
