package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * rpa_task_step
 * </p>
 *
 * @author ultraman
 * @since 2024-12-20
 */
public enum RpaTaskStep {

    _0("0", "头信息"),
    _1("1", "明细信息"),
    _2("2", "取消预约");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RpaTaskStep(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RpaTaskStep fromCode(String code) {
        return Stream.of(RpaTaskStep.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
