package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方对账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-27
 */
public enum MatchStatus {

    WAITING("waiting", "待前序流程处理"),
    TO_BE_RECONCILED("toBeReconciled", "待对账"),
    RECONCILING("reconciling", "对账中"),
    RECONCILED("reconciled", "对账完成"),
    UNRECONCILED("unreconciled", "对账失效"),
    RECON_CONFIRMED("reconConfirmed", "对账确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code) {
        return Stream.of(MatchStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
