package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 冲销状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-25
 */
public enum WriteOffStatus {

    _0("0", "未冲销"),
    _1("1", "被红冲"),
    _2("2", "被蓝冲"),
    _3("3", "红冲"),
    _4("4", "蓝冲");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WriteOffStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WriteOffStatus fromCode(String code) {
        return Stream.of(WriteOffStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
