package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * goods_receive_note
 * </p>
 *
 * @author ultraman
 * @since 2023-05-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsReceiveNote implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 是否是最新版本
   */
  private Boolean latest;
  /**
   * 原始单据Id数组
   */
  private String srcids;
  /**
   * 数据MD5摘要
   */
  private String md5;
  /**
   * 所属租户
   */
  private String belongTenant;
  /**
   * 商超账号
   */
  private String collectionAccount;
  /**
   * 实际收货日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiveDate;
  /**
   * 物流方式
   */
  private String logisticsType;
  /**
   * 发货单号
   */
  private String deliverNo;
  /**
   * 收货单号
   */
  private String receiveNo;
  /**
   * 版本号
   */
  private String versionNo;
  /**
   * 单据类型
   */
  private String receiptType;
  /**
   * 创建人id
   */
  private String createId;
  /**
   * 创建人名称
   */
  private String createName;
  /**
   * 创建日期
   */
  private String createDate;
  /**
   * 审核人id
   */
  private String checkerId;
  /**
   * 审核人名称
   */
  private String checkerName;
  /**
   * 审核日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkDate;
  /**
   * 投单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendDate;
  /**
   * 收货单取消日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime grnCancelDate;
  /**
   * 订单类型
   */
  private String poType;
  /**
   * 采购订单编号
   */
  private String poNo;
  /**
   * 收货单商品总数
   */
  private BigDecimal poItemQty;
  /**
   * 收货单总金额
   */
  private BigDecimal totalAmt;
  /**
   * 收货单不含税金额
   */
  private BigDecimal totalAmtWithoutTax;
  /**
   * 收货单税额
   */
  private BigDecimal poTaxAmt;
  /**
   * 折扣总金额
   */
  private BigDecimal discountTotalAmt;
  /**
   * 结算单号
   */
  private String statementNo;
  /**
   * 结算状态
   */
  private String statementStatus;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * 购方公司名称
   */
  private String purchaseCompanyName;
  /**
   * 购方公司编码
   */
  private String purchaseCompanyCode;
  /**
   * 购方统一社会信用代码
   */
  private String purchaseCompanyTaxNo;
  /**
   * 购方接收部门编码
   */
  private String purchaseReceiveOrgCode;
  /**
   * 购方接收部门名称
   */
  private String purchaseReceiveOrgName;
  /**
   * 购方门店编码
   */
  private String purchaseStoreCode;
  /**
   * 购方门店名称
   */
  private String purchaseStoreName;
  /**
   * 购方门店地址
   */
  private String purchaseStoreAddress;
  /**
   * 购方门店电话
   */
  private String purchaseStoreTel;
  /**
   * 购方门店GLN
   */
  private String purchaseStoreGLN;
  /**
   * 区域编码
   */
  private String regionCode;
  /**
   * 区域名称
   */
  private String regionName;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方统一社会信用代码
   */
  private String sellerCompanyTaxNo;
  /**
   * 销方编码
   */
  private String sellerCode;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 备注
   */
  private String remark;
  /**
   * 扩展字段_字符串_1
   */
  private String extStr1;
  /**
   * 扩展字段_字符串_2
   */
  private String extStr2;
  /**
   * 扩展字段_字符串_3
   */
  private String extStr3;
  /**
   * 扩展字段_字符串_4
   */
  private String extStr4;
  /**
   * 扩展字段_字符串_5
   */
  private String extStr5;
  /**
   * 扩展字段_字符串_6
   */
  private String extStr6;
  /**
   * 扩展字段_字符串_7
   */
  private String extStr7;
  /**
   * 扩展字段_字符串_8
   */
  private String extStr8;
  /**
   * 扩展字段_字符串_9
   */
  private String extStr9;
  /**
   * 扩展字段_字符串_10
   */
  private String extStr10;
  /**
   * 模版变量Id
   */
  private String vVariableId;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 收货状态
   */
  private String receiveStatus;
  /**
   * 价格方式
   */
  private String priceStatus;
  /**
   * 转换方式
   */
  private String docTransformer;
  /**
   * 业务id字段
   */
  private Long businessId;
  /**
   * 发货日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryDate;
  /**
   * 销方公司编码
   */
  private String sellerCompanyCode;
  /**
   * 销方公司名称
   */
  private String sellerCompanyName;
  /**
   * 业务Id
   */
  private String pBusinessId;
  /**
   * 手工采购订单号
   */
  private String manualPONo;
  /**
   * 预计到货日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expectReceiveDate;
  /**
   * 业态编码
   */
  private String purchaseBusinessTypeNo;
  /**
   * 业态名称
   */
  private String purchaseBusinessTypeName;
  /**
   * 单据来源
   */
  private String pSourceFrom;
  /**
   * 销方客户类型
   */
  private String sCustomerType;
  /**
   * 销方销售组编码
   */
  private String sSalesGroupCode;
  /**
   * 销方销售组名称
   */
  private String sSalesGroupName;
  /**
   * 销方对账状态
   */
  private String pSellerReconStatus;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("md5", md5);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("receiveDate", BocpGenUtils.toTimestamp(receiveDate));
      map.put("logisticsType", logisticsType);
      map.put("deliverNo", deliverNo);
      map.put("receiveNo", receiveNo);
      map.put("versionNo", versionNo);
      map.put("receiptType", receiptType);
      map.put("createId", createId);
      map.put("createName", createName);
      map.put("createDate", createDate);
      map.put("checkerId", checkerId);
      map.put("checkerName", checkerName);
      map.put("checkDate", BocpGenUtils.toTimestamp(checkDate));
      map.put("sendDate", BocpGenUtils.toTimestamp(sendDate));
      map.put("grnCancelDate", BocpGenUtils.toTimestamp(grnCancelDate));
      map.put("poType", poType);
      map.put("poNo", poNo);
      map.put("poItemQty", poItemQty);
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("poTaxAmt", poTaxAmt);
      map.put("discountTotalAmt", discountTotalAmt);
      map.put("statementNo", statementNo);
      map.put("statementStatus", statementStatus);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseReceiveOrgCode", purchaseReceiveOrgCode);
      map.put("purchaseReceiveOrgName", purchaseReceiveOrgName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchaseStoreAddress", purchaseStoreAddress);
      map.put("purchaseStoreTel", purchaseStoreTel);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("sellerName", sellerName);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCode", sellerCode);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("remark", remark);
      map.put("extStr1", extStr1);
      map.put("extStr2", extStr2);
      map.put("extStr3", extStr3);
      map.put("extStr4", extStr4);
      map.put("extStr5", extStr5);
      map.put("extStr6", extStr6);
      map.put("extStr7", extStr7);
      map.put("extStr8", extStr8);
      map.put("extStr9", extStr9);
      map.put("extStr10", extStr10);
      map.put("vVariableId", vVariableId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("receiveStatus", receiveStatus);
      map.put("priceStatus", priceStatus);
      map.put("docTransformer", docTransformer);
      map.put("businessId", businessId);
      map.put("deliveryDate", BocpGenUtils.toTimestamp(deliveryDate));
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("pBusinessId", pBusinessId);
      map.put("manualPONo", manualPONo);
      map.put("expectReceiveDate", BocpGenUtils.toTimestamp(expectReceiveDate));
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("pSourceFrom", pSourceFrom);
      map.put("sCustomerType", sCustomerType);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("pSellerReconStatus", pSellerReconStatus);

      return map;
  }

  public static GoodsReceiveNote fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsReceiveNote entity = new GoodsReceiveNote();

    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiveDate(null);
      }
    }
    if(map.containsKey("logisticsType")) {
      Object obj = map.get("logisticsType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliverNo")) {
      Object obj = map.get("deliverNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliverNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveNo")) {
      Object obj = map.get("receiveNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createId")) {
      Object obj = map.get("createId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createName")) {
      Object obj = map.get("createName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerId")) {
      Object obj = map.get("checkerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkDate")) {
      Object obj = map.get("checkDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendDate(null);
      }
    }
    if(map.containsKey("grnCancelDate")) {
      Object obj = map.get("grnCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGrnCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGrnCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrnCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGrnCancelDate(null);
      }
    }
    if(map.containsKey("poType")) {
      Object obj = map.get("poType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poItemQty")) {
      Object obj = map.get("poItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poTaxAmt")) {
      Object obj = map.get("poTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementStatus")) {
      Object obj = map.get("statementStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseReceiveOrgCode")) {
      Object obj = map.get("purchaseReceiveOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseReceiveOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseReceiveOrgName")) {
      Object obj = map.get("purchaseReceiveOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseReceiveOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreTel")) {
      Object obj = map.get("purchaseStoreTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr1")) {
      Object obj = map.get("extStr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr2")) {
      Object obj = map.get("extStr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr3")) {
      Object obj = map.get("extStr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr4")) {
      Object obj = map.get("extStr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr5")) {
      Object obj = map.get("extStr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr6")) {
      Object obj = map.get("extStr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr7")) {
      Object obj = map.get("extStr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr8")) {
      Object obj = map.get("extStr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr9")) {
      Object obj = map.get("extStr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr10")) {
      Object obj = map.get("extStr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vVariableId")) {
      Object obj = map.get("vVariableId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVVariableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveStatus")) {
      Object obj = map.get("receiveStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryDate(null);
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualPONo")) {
      Object obj = map.get("manualPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expectReceiveDate")) {
      Object obj = map.get("expectReceiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpectReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setExpectReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpectReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpectReceiveDate(null);
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSellerReconStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReceiveDate(null);
      }
    }
    if(map.containsKey("logisticsType")) {
      Object obj = map.get("logisticsType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLogisticsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliverNo")) {
      Object obj = map.get("deliverNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeliverNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveNo")) {
      Object obj = map.get("receiveNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createId")) {
      Object obj = map.get("createId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createName")) {
      Object obj = map.get("createName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerId")) {
      Object obj = map.get("checkerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkDate")) {
      Object obj = map.get("checkDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSendDate(null);
      }
    }
    if(map.containsKey("grnCancelDate")) {
      Object obj = map.get("grnCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGrnCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGrnCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGrnCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGrnCancelDate(null);
      }
    }
    if(map.containsKey("poType")) {
      Object obj = map.get("poType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poItemQty")) {
      Object obj = map.get("poItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poTaxAmt")) {
      Object obj = map.get("poTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPoTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPoTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPoTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPoTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPoTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementStatus")) {
      Object obj = map.get("statementStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseReceiveOrgCode")) {
      Object obj = map.get("purchaseReceiveOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseReceiveOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseReceiveOrgName")) {
      Object obj = map.get("purchaseReceiveOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseReceiveOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreTel")) {
      Object obj = map.get("purchaseStoreTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr1")) {
      Object obj = map.get("extStr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr2")) {
      Object obj = map.get("extStr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr3")) {
      Object obj = map.get("extStr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr4")) {
      Object obj = map.get("extStr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr5")) {
      Object obj = map.get("extStr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr6")) {
      Object obj = map.get("extStr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr7")) {
      Object obj = map.get("extStr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr8")) {
      Object obj = map.get("extStr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr9")) {
      Object obj = map.get("extStr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr10")) {
      Object obj = map.get("extStr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtStr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vVariableId")) {
      Object obj = map.get("vVariableId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVVariableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveStatus")) {
      Object obj = map.get("receiveStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPriceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBusinessId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeliveryDate(null);
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualPONo")) {
      Object obj = map.get("manualPONo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setManualPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expectReceiveDate")) {
      Object obj = map.get("expectReceiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExpectReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setExpectReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setExpectReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setExpectReceiveDate(null);
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSellerReconStatus")) {
      Object obj = map.get("pSellerReconStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSellerReconStatus((String)obj);
        }
      } else{
      }
    }
  }
}
