package com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation;

import com.xforceplus.ultraman.app.arterydocument.metadata.validator.UltramanEmailConstraintValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <p>
 * CheckUltramanEnum
 * </p>
 *
 * @author ultraman
 * @since 2023-05-25
 */
@Target({ FIELD, METHOD, PARAMETER, ANNOTATION_TYPE, TYPE_USE })
@Retention(RUNTIME)
@Constraint(validatedBy = UltramanEmailConstraintValidator.class)
@Documented
public @interface CheckUltramanEmail {
    String message() default "{CheckUltramanEmail." + "message}";

    Class<?>[] groups() default { };

    Class<? extends Payload>[] payload() default { };

    String type();

    String emailSuffixes();
}
