package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * billing_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum BillingType {

    NORMAL("NORMAL", "正常"),
    ADJUSTED("ADJUSTED", "调整"),
    WRITE_OFF("WRITE_OFF", "红冲"),
    CANCEL_WRITE_OFF("CANCEL_WRITE_OFF", "蓝冲"),
    OTHERS("OTHERS", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingType fromCode(String code) {
        return Stream.of(BillingType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
