package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * capture_method
 * </p>
 *
 * @author ultraman
 * @since 2023-12-24
 */
public enum CaptureMethod {

    WEBPAGE("WEBPAGE", "网页采集"),
    API("API", "接口采集"),
    FILE("FILE", "文件采集");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CaptureMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CaptureMethod fromCode(String code) {
        return Stream.of(CaptureMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
