package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_tag_level
 * </p>
 *
 * @author ultraman
 * @since 2023-12-28
 */
public enum BusinessTagLevel {

    _0("0", "平台级"),
    _1("1", "租户级");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessTagLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessTagLevel fromCode(String code) {
        return Stream.of(BusinessTagLevel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
