package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp_transmit_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-28
 */
public enum ErpTransmitStatus {

    _0("0", "未传输"),
    _1("1", "成功"),
    _2("2", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErpTransmitStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErpTransmitStatus fromCode(String code) {
        return Stream.of(ErpTransmitStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
