package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * flow_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-28
 */
public enum FlowStatus {

    SUCCESS("success", "成功"),
    FAILED("failed", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FlowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FlowStatus fromCode(String code) {
        return Stream.of(FlowStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
