package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * transfer_status
 * </p>
 *
 * @author ultraman
 * @since 2023-12-28
 */
public enum TransferStatus {

    SUCCESS("success", "成功"),
    ERROR("error", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TransferStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransferStatus fromCode(String code) {
        return Stream.of(TransferStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
