package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * billing_ref_settlement_binding_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-05
 */
public enum BillingRefSettlementBindingStatus {

    _0("0", "未绑定"),
    _1("1", "已绑定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillingRefSettlementBindingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillingRefSettlementBindingStatus fromCode(String code) {
        return Stream.of(BillingRefSettlementBindingStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
