package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * settlement_source_from
 * </p>
 *
 * @author ultraman
 * @since 2024-01-05
 */
public enum SettlementSourceFrom {

    _1("1", "商超系统"),
    _2("2", "线上对账销方上传"),
    _3("3", "线上对账销方创建"),
    _4("4", "线下对账销方创建");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementSourceFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementSourceFrom fromCode(String code) {
        return Stream.of(SettlementSourceFrom.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
