package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pos_approval_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
public enum PosApprovalStatus {

    _0("0", "未审核"),
    _1("1", "审核通过"),
    _2("2", "审核不通过"),
    _3("3", "无需审核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PosApprovalStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PosApprovalStatus fromCode(String code) {
        return Stream.of(PosApprovalStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
