package com.xforceplus.ultraman.app.arterydocument.metadata.validator;

import com.xforceplus.ultraman.app.arterydocument.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.arterydocument.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PSourceFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PSourceFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerClearingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerClearingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerClearingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerOffsetStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerOffsetStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerOffsetStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementSourceFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementSourceFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementSourceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoInvoiceReasonDesc.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoInvoiceReasonDesc.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoInvoiceReasonDesc.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WriteOffType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WriteOffType.class.getSimpleName());
            }
        }
        if(clazz.equals(WriteOffStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WriteOffStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WriteOffStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingRefSettlementBindingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingRefSettlementBindingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingRefSettlementBindingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillingType.class.getSimpleName());
            }
        }
        if(clazz.equals(RedInvoiceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedInvoiceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(TransferStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TransferStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DocumentType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DocumentType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DocumentType.class.getSimpleName());
            }
        }
        if(clazz.equals(PageElementName.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PageElementName.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PageElementName.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpenseDetailSourceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExpenseDetailSourceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExpenseDetailSourceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpTransmitStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErpTransmitStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErpTransmitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessTagLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessTagLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessTagLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(SupportStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SupportStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SupportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CaptureMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CaptureMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CaptureMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(PosApprovalStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PosApprovalStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PosApprovalStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BatchTransferStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BatchTransferStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BatchTransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataIssueStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataIssueStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataIssueStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(StatisticalType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StatisticalType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StatisticalType.class.getSimpleName());
            }
        }
        if(clazz.equals(CaptureType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CaptureType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CaptureType.class.getSimpleName());
            }
        }
        if(clazz.equals(ActiveStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ActiveStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ActiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConversionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WarningStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WarningStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WarningStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SendFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SendFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SendFlag.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
