package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * conversion_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
public enum ConversionStatus {

    _1("1", "是"),
    _0("0", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ConversionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConversionStatus fromCode(String code) {
        return Stream.of(ConversionStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
