package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * document_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
public enum DocumentType {

    PO("PO", "采购订单"),
    GRN("GRN", "收货单"),
    RTV("RTV", "退货单"),
    IR("IR", "库存"),
    POS("POS", "POS"),
    SO("SO", "销售订单"),
    BOS("BOS", "结算单"),
    BOP("BOP", "付款单"),
    BILLING("BILLING", "billing单"),
    ESD("ESD", "费用明细");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentType fromCode(String code) {
        return Stream.of(DocumentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
