package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * p_source_from
 * </p>
 *
 * @author ultraman
 * @since 2024-01-09
 */
public enum PSourceFrom {

    _1("1", "商超网站"),
    _2("2", "线下上传"),
    _3("3", "销方创建");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PSourceFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PSourceFrom fromCode(String code) {
        return Stream.of(PSourceFrom.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
