package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * suit_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-19
 */
public enum SuitType {

    是("是", "是"),
    否("否", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SuitType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SuitType fromCode(String code) {
        return Stream.of(SuitType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
