package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * support_status
 * </p>
 *
 * @author ultraman
 * @since 2024-01-19
 */
public enum SupportStatus {

    YES("YES", "已支持"),
    NO("NO", "不支持");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SupportStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SupportStatus fromCode(String code) {
        return Stream.of(SupportStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
