package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_status
 * </p>
 *
 * @author ultraman
 * @since 2024-02-20
 */
public enum DataStatus {

    ADD("add", "新增"),
    DELETE("delete", "删除"),
    NOCHANGE("nochange", "无变化");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataStatus fromCode(String code) {
        return Stream.of(DataStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
