package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp_callback_status
 * </p>
 *
 * @author ultraman
 * @since 2024-02-20
 */
public enum ErpCallbackStatus {

    _0("0", "未反馈"),
    _1("1", "成功"),
    _2("2", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErpCallbackStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErpCallbackStatus fromCode(String code) {
        return Stream.of(ErpCallbackStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
