package com.xforceplus.ultraman.app.arterydocument.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * goods_type
 * </p>
 *
 * @author ultraman
 * @since 2024-02-20
 */
public enum GoodsType {

    _1("1", "单品"),
    _2("2", "捆绑装（不同税率）"),
    _3("3", "大礼包");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GoodsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsType fromCode(String code) {
        return Stream.of(GoodsType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
