package com.xforceplus.ultraman.app.arterydocument.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * inventory
 * </p>
 *
 * @author ultraman
 * @since 2024-02-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Inventory implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 是否是最新版本
   */
  private Boolean latest;
  /**
   * 原始单据Id数组
   */
  private String srcids;
  /**
   * 所属租户
   */
  private String belongTenant;
  /**
   * 商超账号
   */
  private String collectionAccount;
  /**
   * 采集批次
   */
  private String collectionBatch;
  /**
   * 采集日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectionDate;
  /**
   * 购方统一社会信用代码
   */
  private String purchaseCompanyTaxNo;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * 购方公司编码
   */
  private String purchaseCompanyCode;
  /**
   * 购方公司名称
   */
  private String purchaseCompanyName;
  /**
   * 区域编码
   */
  private String regionCode;
  /**
   * 区域名称
   */
  private String regionName;
  /**
   * 购方门店编码
   */
  private String purchaseStoreCode;
  /**
   * 购方门店GLN
   */
  private String purchaseStoreGLN;
  /**
   * 购方门店名称
   */
  private String purchaseStoreName;
  /**
   * 品类编码
   */
  private String categoryCode;
  /**
   * 品类名称
   */
  private String categoryName;
  /**
   * 销方编码
   */
  private String sellerCode;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 商品编码
   */
  private String itemCode;
  /**
   * 商品条码
   */
  private String barcode;
  /**
   * 商品子编码
   */
  private String itemSubCode;
  /**
   * 商品名称
   */
  private String itemDesc;
  /**
   * 品牌
   */
  private String brand;
  /**
   * 规格
   */
  private String standards;
  /**
   * 型号
   */
  private String model;
  /**
   * 商品状态
   */
  private BigDecimal itemStatus;
  /**
   * 基本单位
   */
  private String unit;
  /**
   * 期间类型
   */
  private String sectionType;
  /**
   * 年/月/日
   */
  private String sectionDate;
  /**
   * 进货数量
   */
  private String purchaseQty;
  /**
   * 进货金额
   */
  private BigDecimal purchaseAmt;
  /**
   * 年/月/日均进货量
   */
  private BigDecimal averagePurchaseAmt;
  /**
   * 销售数量
   */
  private BigDecimal salesQty;
  /**
   * 销售金额
   */
  private BigDecimal saleAmt;
  /**
   * 年/月/日均销售量
   */
  private BigDecimal averageSaleQty;
  /**
   * 库存日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime stockDate;
  /**
   * 库存余额数量
   */
  private BigDecimal stockQty;
  /**
   * 库存余额金额
   */
  private BigDecimal stockAmt;
  /**
   * 在途数量
   */
  private BigDecimal transitQty;
  /**
   * 在途金额
   */
  private BigDecimal transitAmt;
  /**
   * 备注
   */
  private String remark;
  /**
   * 扩展字段_字符串_1
   */
  private String extstr1;
  /**
   * 扩展字段_字符串_2
   */
  private String extstr2;
  /**
   * 扩展字段_字符串_3
   */
  private String extstr3;
  /**
   * 扩展字段_字符串_4
   */
  private String extstr4;
  /**
   * 扩展字段_字符串_5
   */
  private String extstr5;
  /**
   * 扩展字段_字符串_6
   */
  private String extstr6;
  /**
   * 扩展字段_字符串_7
   */
  private String extstr7;
  /**
   * 扩展字段_字符串_8
   */
  private String extstr8;
  /**
   * 扩展字段_字符串_9
   */
  private String extstr9;
  /**
   * 扩展字段_字符串_10
   */
  private String extstr10;
  /**
   * 模版变量Id
   */
  private String vvariableid;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 转换方式信息
   */
  private String docTransformer;
  /**
   * 业务id
   */
  private String pBusinessId;
  /**
   * 版本号
   */
  private String versionNo;
  /**
   * 业态编码
   */
  private String purchaseBusinessTypeNo;
  /**
   * 业态名称
   */
  private String purchaseBusinessTypeName;
  /**
   * 销方版本号
   */
  private String sVersionNo;
  /**
   * 售达方编码
   */
  private String sSoldToCode;
  /**
   * 售达方名称
   */
  private String sSoldToName;
  /**
   * 送达方编码
   */
  private String sShipToCode;
  /**
   * 送达方名称
   */
  private String sShipToName;
  /**
   * 客户组编码
   */
  private String sCustomerGroupCode;
  /**
   * 客户组名称
   */
  private String sCustomerGroupName;
  /**
   * 客户类型
   */
  private String sCustomerType;
  /**
   * 客户编码
   */
  private String sCustomerCode;
  /**
   * 客户名称
   */
  private String sCustomerName;
  /**
   * 业务单元编码
   */
  private String sBuCode;
  /**
   * 业务单元名称
   */
  private String sBuName;
  /**
   * 销售公司编码
   */
  private String sCompanyCode;
  /**
   * 销售公司名称
   */
  private String sCompanyName;
  /**
   * 销售公司税号
   */
  private String sCompanyTaxNo;
  /**
   * 销售组织编码
   */
  private String sSalesOrganizationCode;
  /**
   * 销售组织名称
   */
  private String sSalesOrganizationName;
  /**
   * 价格方式
   */
  private Long priceStatus;
  /**
   * 商超原单文件地址
   */
  private String pSourceFileURL;
  /**
   * 统一单据标记
   */
  private Boolean pUnifyDocFlag;
  /**
   * 租户单据标记
   */
  private Boolean pTenantDocFlag;
  /**
   * 转换批次号
   */
  private String batchNumberOD2UD;
  /**
   * 删除标记
   */
  private Boolean pDeleteFlag;
  /**
   * 数据状态标记
   */
  private String dataStatus;
  /**
   * 下发ID
   */
  private String dataIssueID;
  /**
   * 统计头MD5
   */
  private String statisticalHeaderMD5;
  /**
   * 数据MD5
   */
  private String dataMD5;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("collectionBatch", collectionBatch);
      map.put("collectionDate", BocpGenUtils.toTimestamp(collectionDate));
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("categoryCode", categoryCode);
      map.put("categoryName", categoryName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("itemDesc", itemDesc);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("model", model);
      map.put("itemStatus", itemStatus);
      map.put("unit", unit);
      map.put("sectionType", sectionType);
      map.put("sectionDate", sectionDate);
      map.put("purchaseQty", purchaseQty);
      map.put("purchaseAmt", purchaseAmt);
      map.put("averagePurchaseAmt", averagePurchaseAmt);
      map.put("salesQty", salesQty);
      map.put("saleAmt", saleAmt);
      map.put("averageSaleQty", averageSaleQty);
      map.put("stockDate", BocpGenUtils.toTimestamp(stockDate));
      map.put("stockQty", stockQty);
      map.put("stockAmt", stockAmt);
      map.put("transitQty", transitQty);
      map.put("transitAmt", transitAmt);
      map.put("remark", remark);
      map.put("extstr1", extstr1);
      map.put("extstr2", extstr2);
      map.put("extstr3", extstr3);
      map.put("extstr4", extstr4);
      map.put("extstr5", extstr5);
      map.put("extstr6", extstr6);
      map.put("extstr7", extstr7);
      map.put("extstr8", extstr8);
      map.put("extstr9", extstr9);
      map.put("extstr10", extstr10);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("docTransformer", docTransformer);
      map.put("pBusinessId", pBusinessId);
      map.put("versionNo", versionNo);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("sVersionNo", sVersionNo);
      map.put("sSoldToCode", sSoldToCode);
      map.put("sSoldToName", sSoldToName);
      map.put("sShipToCode", sShipToCode);
      map.put("sShipToName", sShipToName);
      map.put("sCustomerGroupCode", sCustomerGroupCode);
      map.put("sCustomerGroupName", sCustomerGroupName);
      map.put("sCustomerType", sCustomerType);
      map.put("sCustomerCode", sCustomerCode);
      map.put("sCustomerName", sCustomerName);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sCompanyCode", sCompanyCode);
      map.put("sCompanyName", sCompanyName);
      map.put("sCompanyTaxNo", sCompanyTaxNo);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("priceStatus", priceStatus);
      map.put("pSourceFileURL", pSourceFileURL);
      map.put("pUnifyDocFlag", pUnifyDocFlag);
      map.put("pTenantDocFlag", pTenantDocFlag);
      map.put("batchNumberOD2UD", batchNumberOD2UD);
      map.put("pDeleteFlag", pDeleteFlag);
      map.put("dataStatus", dataStatus);
      map.put("dataIssueID", dataIssueID);
      map.put("statisticalHeaderMD5", statisticalHeaderMD5);
      map.put("dataMD5", dataMD5);

      return map;
  }

  public static Inventory fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Inventory entity = new Inventory();

    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectionDate(null);
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemStatus")) {
      Object obj = map.get("itemStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setItemStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setItemStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setItemStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionType")) {
      Object obj = map.get("sectionType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionDate")) {
      Object obj = map.get("sectionDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSectionDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQty")) {
      Object obj = map.get("purchaseQty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAmt")) {
      Object obj = map.get("purchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averagePurchaseAmt")) {
      Object obj = map.get("averagePurchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAveragePurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAveragePurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("saleAmt")) {
      Object obj = map.get("saleAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSaleAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSaleAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSaleAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSaleAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averageSaleQty")) {
      Object obj = map.get("averageSaleQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAverageSaleQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAverageSaleQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAverageSaleQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAverageSaleQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAverageSaleQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStockDate(null);
      }
    }
    if(map.containsKey("stockQty")) {
      Object obj = map.get("stockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockAmt")) {
      Object obj = map.get("stockAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitQty")) {
      Object obj = map.get("transitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitAmt")) {
      Object obj = map.get("transitAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransitAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFileURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumberOD2UD((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataIssueID")) {
      Object obj = map.get("dataIssueID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataIssueID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticalHeaderMD5")) {
      Object obj = map.get("statisticalHeaderMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatisticalHeaderMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCollectionDate(null);
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemStatus")) {
      Object obj = map.get("itemStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setItemStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setItemStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setItemStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setItemStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setItemStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionType")) {
      Object obj = map.get("sectionType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionDate")) {
      Object obj = map.get("sectionDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSectionDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQty")) {
      Object obj = map.get("purchaseQty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAmt")) {
      Object obj = map.get("purchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averagePurchaseAmt")) {
      Object obj = map.get("averagePurchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAveragePurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAveragePurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAveragePurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAveragePurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAveragePurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("saleAmt")) {
      Object obj = map.get("saleAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setSaleAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setSaleAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setSaleAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setSaleAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averageSaleQty")) {
      Object obj = map.get("averageSaleQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAverageSaleQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAverageSaleQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAverageSaleQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAverageSaleQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAverageSaleQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setStockDate(null);
      }
    }
    if(map.containsKey("stockQty")) {
      Object obj = map.get("stockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockAmt")) {
      Object obj = map.get("stockAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setStockAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setStockAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setStockAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setStockAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setStockAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitQty")) {
      Object obj = map.get("transitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTransitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTransitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTransitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTransitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTransitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitAmt")) {
      Object obj = map.get("transitAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTransitAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTransitAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTransitAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTransitAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTransitAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPSourceFileURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchNumberOD2UD((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataIssueID")) {
      Object obj = map.get("dataIssueID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataIssueID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticalHeaderMD5")) {
      Object obj = map.get("statisticalHeaderMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatisticalHeaderMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataMD5((String)obj);
        }
      } else{
      }
    }
  }
}
