package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.CustomerGoods;
import com.xforceplus.ultraman.app.arterydocument.service.ICustomerGoodsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-30
 */
@RestController
public class CustomerGoodsController {

  @Autowired
  private ICustomerGoodsService customerGoodsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerGoods ${table.comment}
   * @return
   */
  @GetMapping("/customergoodss" )
  public XfR getCustomerGoodss(XfPage page, CustomerGoods customerGoods) {
    return XfR.ok(customerGoodsServiceImpl.page(page, Wrappers.query(customerGoods)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customergoodss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerGoodsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerGoods ${table.comment}
   * @return XfR
   */
  @PostMapping("/customergoodss")
  public XfR save(@RequestBody CustomerGoods customerGoods) {
     return XfR.ok(customerGoodsServiceImpl.save(customerGoods));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerGoods ${table.comment}
   * @return XfR
   */
  @PutMapping("/customergoodss/{id}")
  public XfR putUpdate(@RequestBody CustomerGoods customerGoods,@PathVariable Long id) {
      customerGoods.setId(id);
      return XfR.ok(customerGoodsServiceImpl.updateById(customerGoods));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerGoods ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customergoodss/{id}")
  public XfR patchUpdate(@RequestBody CustomerGoods customerGoods,@PathVariable Long id) {
      CustomerGoods upcustomerGoods = customerGoodsServiceImpl.getById(id);
      if(upcustomerGoods != null){
        upcustomerGoods = ObjectCopyUtils.copyProperties(customerGoods,upcustomerGoods,true);
      }
      return XfR.ok(customerGoodsServiceImpl.updateById(upcustomerGoods));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customergoodss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerGoodsServiceImpl.removeById(id));
  }

  @PostMapping("/customergoodss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_goods");
     params.put("request", condition);

     return XfR.ok(customerGoodsServiceImpl.querys(params));
  }

}
