package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.GoodsReceiveNoteDetail;
import com.xforceplus.ultraman.app.arterydocument.service.IGoodsReceiveNoteDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-30
 */
@RestController
public class GoodsReceiveNoteDetailController {

  @Autowired
  private IGoodsReceiveNoteDetailService goodsReceiveNoteDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsReceiveNoteDetail ${table.comment}
   * @return
   */
  @GetMapping("/goodsreceivenotedetails" )
  public XfR getGoodsReceiveNoteDetails(XfPage page, GoodsReceiveNoteDetail goodsReceiveNoteDetail) {
    return XfR.ok(goodsReceiveNoteDetailServiceImpl.page(page, Wrappers.query(goodsReceiveNoteDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsreceivenotedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsReceiveNoteDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsReceiveNoteDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsreceivenotedetails")
  public XfR save(@RequestBody GoodsReceiveNoteDetail goodsReceiveNoteDetail) {
     return XfR.ok(goodsReceiveNoteDetailServiceImpl.save(goodsReceiveNoteDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsReceiveNoteDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsreceivenotedetails/{id}")
  public XfR putUpdate(@RequestBody GoodsReceiveNoteDetail goodsReceiveNoteDetail,@PathVariable Long id) {
      goodsReceiveNoteDetail.setId(id);
      return XfR.ok(goodsReceiveNoteDetailServiceImpl.updateById(goodsReceiveNoteDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsReceiveNoteDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsreceivenotedetails/{id}")
  public XfR patchUpdate(@RequestBody GoodsReceiveNoteDetail goodsReceiveNoteDetail,@PathVariable Long id) {
      GoodsReceiveNoteDetail upgoodsReceiveNoteDetail = goodsReceiveNoteDetailServiceImpl.getById(id);
      if(upgoodsReceiveNoteDetail != null){
        upgoodsReceiveNoteDetail = ObjectCopyUtils.copyProperties(goodsReceiveNoteDetail,upgoodsReceiveNoteDetail,true);
      }
      return XfR.ok(goodsReceiveNoteDetailServiceImpl.updateById(upgoodsReceiveNoteDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsreceivenotedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsReceiveNoteDetailServiceImpl.removeById(id));
  }

  @PostMapping("/goodsreceivenotedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_receive_note_detail");
     params.put("request", condition);

     return XfR.ok(goodsReceiveNoteDetailServiceImpl.querys(params));
  }

}
