package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.ReturnToVendorDetail;
import com.xforceplus.ultraman.app.arterydocument.service.IReturnToVendorDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-30
 */
@RestController
public class ReturnToVendorDetailController {

  @Autowired
  private IReturnToVendorDetailService returnToVendorDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param returnToVendorDetail ${table.comment}
   * @return
   */
  @GetMapping("/returntovendordetails" )
  public XfR getReturnToVendorDetails(XfPage page, ReturnToVendorDetail returnToVendorDetail) {
    return XfR.ok(returnToVendorDetailServiceImpl.page(page, Wrappers.query(returnToVendorDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/returntovendordetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(returnToVendorDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param returnToVendorDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/returntovendordetails")
  public XfR save(@RequestBody ReturnToVendorDetail returnToVendorDetail) {
     return XfR.ok(returnToVendorDetailServiceImpl.save(returnToVendorDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param returnToVendorDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/returntovendordetails/{id}")
  public XfR putUpdate(@RequestBody ReturnToVendorDetail returnToVendorDetail,@PathVariable Long id) {
      returnToVendorDetail.setId(id);
      return XfR.ok(returnToVendorDetailServiceImpl.updateById(returnToVendorDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param returnToVendorDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/returntovendordetails/{id}")
  public XfR patchUpdate(@RequestBody ReturnToVendorDetail returnToVendorDetail,@PathVariable Long id) {
      ReturnToVendorDetail upreturnToVendorDetail = returnToVendorDetailServiceImpl.getById(id);
      if(upreturnToVendorDetail != null){
        upreturnToVendorDetail = ObjectCopyUtils.copyProperties(returnToVendorDetail,upreturnToVendorDetail,true);
      }
      return XfR.ok(returnToVendorDetailServiceImpl.updateById(upreturnToVendorDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/returntovendordetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(returnToVendorDetailServiceImpl.removeById(id));
  }

  @PostMapping("/returntovendordetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "return_to_vendor_detail");
     params.put("request", condition);

     return XfR.ok(returnToVendorDetailServiceImpl.querys(params));
  }

}
