package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.ExecutionTask;
import com.xforceplus.ultraman.app.arterydocument.service.IExecutionTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 执行任务主表前端控制器
 *
 * @author ultraman
 * @date 2024-05-11
 */
@RestController
public class ExecutionTaskController {

  @Autowired
  private IExecutionTaskService executionTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param executionTask 执行任务主表
   * @return
   */
  @GetMapping("/executiontasks" )
  public XfR getExecutionTasks(XfPage page, ExecutionTask executionTask) {
    return XfR.ok(executionTaskServiceImpl.page(page, Wrappers.query(executionTask)));
  }

  /**
   * 通过id查询执行任务主表
   * @param  id
   * @return XfR
   */
  @GetMapping("/executiontasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(executionTaskServiceImpl.getById(id));
  }

  /**
   * 新增执行任务主表
   * @param executionTask 执行任务主表
   * @return XfR
   */
  @PostMapping("/executiontasks")
  public XfR save(@RequestBody ExecutionTask executionTask) {
     return XfR.ok(executionTaskServiceImpl.save(executionTask));
  }

  /**
   * 修改-传入修改后的全部数据执行任务主表
   * @param executionTask 执行任务主表
   * @return XfR
   */
  @PutMapping("/executiontasks/{id}")
  public XfR putUpdate(@RequestBody ExecutionTask executionTask,@PathVariable Long id) {
      executionTask.setId(id);
      return XfR.ok(executionTaskServiceImpl.updateById(executionTask));
  }

  /**
   * 修改-传入修改的数据执行任务主表
   * @param executionTask 执行任务主表
   * @return XfR
   */
  @PatchMapping("/executiontasks/{id}")
  public XfR patchUpdate(@RequestBody ExecutionTask executionTask,@PathVariable Long id) {
      ExecutionTask upexecutionTask = executionTaskServiceImpl.getById(id);
      if(upexecutionTask != null){
        upexecutionTask = ObjectCopyUtils.copyProperties(executionTask,upexecutionTask,true);
      }
      return XfR.ok(executionTaskServiceImpl.updateById(upexecutionTask));
  }

  /**
   * 通过id删除执行任务主表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/executiontasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(executionTaskServiceImpl.removeById(id));
  }

  @PostMapping("/executiontasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "execution_task");
     params.put("request", condition);

     return XfR.ok(executionTaskServiceImpl.querys(params));
  }

}
