package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.SettlementDocGRNRTVDetail;
import com.xforceplus.ultraman.app.arterydocument.service.ISettlementDocGRNRTVDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * V2前端控制器
 *
 * @author ultraman
 * @date 2024-05-11
 */
@RestController
public class SettlementDocGRNRTVDetailController {

  @Autowired
  private ISettlementDocGRNRTVDetailService settlementDocGRNRTVDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDocGRNRTVDetail V2
   * @return
   */
  @GetMapping("/settlementdocgrnrtvdetails" )
  public XfR getSettlementDocGRNRTVDetails(XfPage page, SettlementDocGRNRTVDetail settlementDocGRNRTVDetail) {
    return XfR.ok(settlementDocGRNRTVDetailServiceImpl.page(page, Wrappers.query(settlementDocGRNRTVDetail)));
  }

  /**
   * 通过id查询V2
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdocgrnrtvdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDocGRNRTVDetailServiceImpl.getById(id));
  }

  /**
   * 新增V2
   * @param settlementDocGRNRTVDetail V2
   * @return XfR
   */
  @PostMapping("/settlementdocgrnrtvdetails")
  public XfR save(@RequestBody SettlementDocGRNRTVDetail settlementDocGRNRTVDetail) {
     return XfR.ok(settlementDocGRNRTVDetailServiceImpl.save(settlementDocGRNRTVDetail));
  }

  /**
   * 修改-传入修改后的全部数据V2
   * @param settlementDocGRNRTVDetail V2
   * @return XfR
   */
  @PutMapping("/settlementdocgrnrtvdetails/{id}")
  public XfR putUpdate(@RequestBody SettlementDocGRNRTVDetail settlementDocGRNRTVDetail,@PathVariable Long id) {
      settlementDocGRNRTVDetail.setId(id);
      return XfR.ok(settlementDocGRNRTVDetailServiceImpl.updateById(settlementDocGRNRTVDetail));
  }

  /**
   * 修改-传入修改的数据V2
   * @param settlementDocGRNRTVDetail V2
   * @return XfR
   */
  @PatchMapping("/settlementdocgrnrtvdetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementDocGRNRTVDetail settlementDocGRNRTVDetail,@PathVariable Long id) {
      SettlementDocGRNRTVDetail upsettlementDocGRNRTVDetail = settlementDocGRNRTVDetailServiceImpl.getById(id);
      if(upsettlementDocGRNRTVDetail != null){
        upsettlementDocGRNRTVDetail = ObjectCopyUtils.copyProperties(settlementDocGRNRTVDetail,upsettlementDocGRNRTVDetail,true);
      }
      return XfR.ok(settlementDocGRNRTVDetailServiceImpl.updateById(upsettlementDocGRNRTVDetail));
  }

  /**
   * 通过id删除V2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdocgrnrtvdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDocGRNRTVDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdocgrnrtvdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_doc_g_r_n_r_t_v_detail");
     params.put("request", condition);

     return XfR.ok(settlementDocGRNRTVDetailServiceImpl.querys(params));
  }

}
