package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.TenantSalesOrderDetail;
import com.xforceplus.ultraman.app.arterydocument.service.ITenantSalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-11
 */
@RestController
public class TenantSalesOrderDetailController {

  @Autowired
  private ITenantSalesOrderDetailService tenantSalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tenantSalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/tenantsalesorderdetails" )
  public XfR getTenantSalesOrderDetails(XfPage page, TenantSalesOrderDetail tenantSalesOrderDetail) {
    return XfR.ok(tenantSalesOrderDetailServiceImpl.page(page, Wrappers.query(tenantSalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tenantsalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tenantSalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tenantSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/tenantsalesorderdetails")
  public XfR save(@RequestBody TenantSalesOrderDetail tenantSalesOrderDetail) {
     return XfR.ok(tenantSalesOrderDetailServiceImpl.save(tenantSalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tenantSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/tenantsalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody TenantSalesOrderDetail tenantSalesOrderDetail,@PathVariable Long id) {
      tenantSalesOrderDetail.setId(id);
      return XfR.ok(tenantSalesOrderDetailServiceImpl.updateById(tenantSalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tenantSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tenantsalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody TenantSalesOrderDetail tenantSalesOrderDetail,@PathVariable Long id) {
      TenantSalesOrderDetail uptenantSalesOrderDetail = tenantSalesOrderDetailServiceImpl.getById(id);
      if(uptenantSalesOrderDetail != null){
        uptenantSalesOrderDetail = ObjectCopyUtils.copyProperties(tenantSalesOrderDetail,uptenantSalesOrderDetail,true);
      }
      return XfR.ok(tenantSalesOrderDetailServiceImpl.updateById(uptenantSalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tenantsalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tenantSalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/tenantsalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tenant_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(tenantSalesOrderDetailServiceImpl.querys(params));
  }

}
