package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.NewPosBackTracking;
import com.xforceplus.ultraman.app.arterydocument.service.INewPosBackTrackingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * POS自动补录前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class NewPosBackTrackingController {

  @Autowired
  private INewPosBackTrackingService newPosBackTrackingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param newPosBackTracking POS自动补录
   * @return
   */
  @GetMapping("/newposbacktrackings" )
  public XfR getNewPosBackTrackings(XfPage page, NewPosBackTracking newPosBackTracking) {
    return XfR.ok(newPosBackTrackingServiceImpl.page(page, Wrappers.query(newPosBackTracking)));
  }

  /**
   * 通过id查询POS自动补录
   * @param  id
   * @return XfR
   */
  @GetMapping("/newposbacktrackings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(newPosBackTrackingServiceImpl.getById(id));
  }

  /**
   * 新增POS自动补录
   * @param newPosBackTracking POS自动补录
   * @return XfR
   */
  @PostMapping("/newposbacktrackings")
  public XfR save(@RequestBody NewPosBackTracking newPosBackTracking) {
     return XfR.ok(newPosBackTrackingServiceImpl.save(newPosBackTracking));
  }

  /**
   * 修改-传入修改后的全部数据POS自动补录
   * @param newPosBackTracking POS自动补录
   * @return XfR
   */
  @PutMapping("/newposbacktrackings/{id}")
  public XfR putUpdate(@RequestBody NewPosBackTracking newPosBackTracking,@PathVariable Long id) {
      newPosBackTracking.setId(id);
      return XfR.ok(newPosBackTrackingServiceImpl.updateById(newPosBackTracking));
  }

  /**
   * 修改-传入修改的数据POS自动补录
   * @param newPosBackTracking POS自动补录
   * @return XfR
   */
  @PatchMapping("/newposbacktrackings/{id}")
  public XfR patchUpdate(@RequestBody NewPosBackTracking newPosBackTracking,@PathVariable Long id) {
      NewPosBackTracking upnewPosBackTracking = newPosBackTrackingServiceImpl.getById(id);
      if(upnewPosBackTracking != null){
        upnewPosBackTracking = ObjectCopyUtils.copyProperties(newPosBackTracking,upnewPosBackTracking,true);
      }
      return XfR.ok(newPosBackTrackingServiceImpl.updateById(upnewPosBackTracking));
  }

  /**
   * 通过id删除POS自动补录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/newposbacktrackings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(newPosBackTrackingServiceImpl.removeById(id));
  }

  @PostMapping("/newposbacktrackings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "new_pos_back_tracking");
     params.put("request", condition);

     return XfR.ok(newPosBackTrackingServiceImpl.querys(params));
  }

}
