package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.ReturnToVendor;
import com.xforceplus.ultraman.app.arterydocument.service.IReturnToVendorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class ReturnToVendorController {

  @Autowired
  private IReturnToVendorService returnToVendorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param returnToVendor ${table.comment}
   * @return
   */
  @GetMapping("/returntovendors" )
  public XfR getReturnToVendors(XfPage page, ReturnToVendor returnToVendor) {
    return XfR.ok(returnToVendorServiceImpl.page(page, Wrappers.query(returnToVendor)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/returntovendors/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(returnToVendorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param returnToVendor ${table.comment}
   * @return XfR
   */
  @PostMapping("/returntovendors")
  public XfR save(@RequestBody ReturnToVendor returnToVendor) {
     return XfR.ok(returnToVendorServiceImpl.save(returnToVendor));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param returnToVendor ${table.comment}
   * @return XfR
   */
  @PutMapping("/returntovendors/{id}")
  public XfR putUpdate(@RequestBody ReturnToVendor returnToVendor,@PathVariable Long id) {
      returnToVendor.setId(id);
      return XfR.ok(returnToVendorServiceImpl.updateById(returnToVendor));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param returnToVendor ${table.comment}
   * @return XfR
   */
  @PatchMapping("/returntovendors/{id}")
  public XfR patchUpdate(@RequestBody ReturnToVendor returnToVendor,@PathVariable Long id) {
      ReturnToVendor upreturnToVendor = returnToVendorServiceImpl.getById(id);
      if(upreturnToVendor != null){
        upreturnToVendor = ObjectCopyUtils.copyProperties(returnToVendor,upreturnToVendor,true);
      }
      return XfR.ok(returnToVendorServiceImpl.updateById(upreturnToVendor));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/returntovendors/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(returnToVendorServiceImpl.removeById(id));
  }

  @PostMapping("/returntovendors/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "return_to_vendor");
     params.put("request", condition);

     return XfR.ok(returnToVendorServiceImpl.querys(params));
  }

}
