package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.PurchaseOrderStoreDetail;
import com.xforceplus.ultraman.app.arterydocument.service.IPurchaseOrderStoreDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-06-17
 */
@RestController
public class PurchaseOrderStoreDetailController {

  @Autowired
  private IPurchaseOrderStoreDetailService purchaseOrderStoreDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrderStoreDetail ${table.comment}
   * @return
   */
  @GetMapping("/purchaseorderstoredetails" )
  public XfR getPurchaseOrderStoreDetails(XfPage page, PurchaseOrderStoreDetail purchaseOrderStoreDetail) {
    return XfR.ok(purchaseOrderStoreDetailServiceImpl.page(page, Wrappers.query(purchaseOrderStoreDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorderstoredetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderStoreDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseOrderStoreDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseorderstoredetails")
  public XfR save(@RequestBody PurchaseOrderStoreDetail purchaseOrderStoreDetail) {
     return XfR.ok(purchaseOrderStoreDetailServiceImpl.save(purchaseOrderStoreDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseOrderStoreDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseorderstoredetails/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrderStoreDetail purchaseOrderStoreDetail,@PathVariable Long id) {
      purchaseOrderStoreDetail.setId(id);
      return XfR.ok(purchaseOrderStoreDetailServiceImpl.updateById(purchaseOrderStoreDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseOrderStoreDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseorderstoredetails/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrderStoreDetail purchaseOrderStoreDetail,@PathVariable Long id) {
      PurchaseOrderStoreDetail uppurchaseOrderStoreDetail = purchaseOrderStoreDetailServiceImpl.getById(id);
      if(uppurchaseOrderStoreDetail != null){
        uppurchaseOrderStoreDetail = ObjectCopyUtils.copyProperties(purchaseOrderStoreDetail,uppurchaseOrderStoreDetail,true);
      }
      return XfR.ok(purchaseOrderStoreDetailServiceImpl.updateById(uppurchaseOrderStoreDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorderstoredetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderStoreDetailServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorderstoredetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_order_store_detail");
     params.put("request", condition);

     return XfR.ok(purchaseOrderStoreDetailServiceImpl.querys(params));
  }

}
