package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.MarketAccount;
import com.xforceplus.ultraman.app.arterydocument.service.IMarketAccountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class MarketAccountController {

  @Autowired
  private IMarketAccountService marketAccountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param marketAccount ${table.comment}
   * @return
   */
  @GetMapping("/marketaccounts" )
  public XfR getMarketAccounts(XfPage page, MarketAccount marketAccount) {
    return XfR.ok(marketAccountServiceImpl.page(page, Wrappers.query(marketAccount)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/marketaccounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(marketAccountServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param marketAccount ${table.comment}
   * @return XfR
   */
  @PostMapping("/marketaccounts")
  public XfR save(@RequestBody MarketAccount marketAccount) {
     return XfR.ok(marketAccountServiceImpl.save(marketAccount));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param marketAccount ${table.comment}
   * @return XfR
   */
  @PutMapping("/marketaccounts/{id}")
  public XfR putUpdate(@RequestBody MarketAccount marketAccount,@PathVariable Long id) {
      marketAccount.setId(id);
      return XfR.ok(marketAccountServiceImpl.updateById(marketAccount));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param marketAccount ${table.comment}
   * @return XfR
   */
  @PatchMapping("/marketaccounts/{id}")
  public XfR patchUpdate(@RequestBody MarketAccount marketAccount,@PathVariable Long id) {
      MarketAccount upmarketAccount = marketAccountServiceImpl.getById(id);
      if(upmarketAccount != null){
        upmarketAccount = ObjectCopyUtils.copyProperties(marketAccount,upmarketAccount,true);
      }
      return XfR.ok(marketAccountServiceImpl.updateById(upmarketAccount));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/marketaccounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(marketAccountServiceImpl.removeById(id));
  }

  @PostMapping("/marketaccounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "market_account");
     params.put("request", condition);

     return XfR.ok(marketAccountServiceImpl.querys(params));
  }

}
