package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.MarketAccountOperationRecord;
import com.xforceplus.ultraman.app.arterydocument.service.IMarketAccountOperationRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class MarketAccountOperationRecordController {

  @Autowired
  private IMarketAccountOperationRecordService marketAccountOperationRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param marketAccountOperationRecord ${table.comment}
   * @return
   */
  @GetMapping("/marketaccountoperationrecords" )
  public XfR getMarketAccountOperationRecords(XfPage page, MarketAccountOperationRecord marketAccountOperationRecord) {
    return XfR.ok(marketAccountOperationRecordServiceImpl.page(page, Wrappers.query(marketAccountOperationRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/marketaccountoperationrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(marketAccountOperationRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param marketAccountOperationRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/marketaccountoperationrecords")
  public XfR save(@RequestBody MarketAccountOperationRecord marketAccountOperationRecord) {
     return XfR.ok(marketAccountOperationRecordServiceImpl.save(marketAccountOperationRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param marketAccountOperationRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/marketaccountoperationrecords/{id}")
  public XfR putUpdate(@RequestBody MarketAccountOperationRecord marketAccountOperationRecord,@PathVariable Long id) {
      marketAccountOperationRecord.setId(id);
      return XfR.ok(marketAccountOperationRecordServiceImpl.updateById(marketAccountOperationRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param marketAccountOperationRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/marketaccountoperationrecords/{id}")
  public XfR patchUpdate(@RequestBody MarketAccountOperationRecord marketAccountOperationRecord,@PathVariable Long id) {
      MarketAccountOperationRecord upmarketAccountOperationRecord = marketAccountOperationRecordServiceImpl.getById(id);
      if(upmarketAccountOperationRecord != null){
        upmarketAccountOperationRecord = ObjectCopyUtils.copyProperties(marketAccountOperationRecord,upmarketAccountOperationRecord,true);
      }
      return XfR.ok(marketAccountOperationRecordServiceImpl.updateById(upmarketAccountOperationRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/marketaccountoperationrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(marketAccountOperationRecordServiceImpl.removeById(id));
  }

  @PostMapping("/marketaccountoperationrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "market_account_operation_record");
     params.put("request", condition);

     return XfR.ok(marketAccountOperationRecordServiceImpl.querys(params));
  }

}
