package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.PocBSorder;
import com.xforceplus.ultraman.app.arterydocument.service.IPocBSorderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class PocBSorderController {

  @Autowired
  private IPocBSorderService pocBSorderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pocBSorder ${table.comment}
   * @return
   */
  @GetMapping("/pocbsorders" )
  public XfR getPocBSorders(XfPage page, PocBSorder pocBSorder) {
    return XfR.ok(pocBSorderServiceImpl.page(page, Wrappers.query(pocBSorder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pocbsorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pocBSorderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pocBSorder ${table.comment}
   * @return XfR
   */
  @PostMapping("/pocbsorders")
  public XfR save(@RequestBody PocBSorder pocBSorder) {
     return XfR.ok(pocBSorderServiceImpl.save(pocBSorder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pocBSorder ${table.comment}
   * @return XfR
   */
  @PutMapping("/pocbsorders/{id}")
  public XfR putUpdate(@RequestBody PocBSorder pocBSorder,@PathVariable Long id) {
      pocBSorder.setId(id);
      return XfR.ok(pocBSorderServiceImpl.updateById(pocBSorder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pocBSorder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pocbsorders/{id}")
  public XfR patchUpdate(@RequestBody PocBSorder pocBSorder,@PathVariable Long id) {
      PocBSorder uppocBSorder = pocBSorderServiceImpl.getById(id);
      if(uppocBSorder != null){
        uppocBSorder = ObjectCopyUtils.copyProperties(pocBSorder,uppocBSorder,true);
      }
      return XfR.ok(pocBSorderServiceImpl.updateById(uppocBSorder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pocbsorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pocBSorderServiceImpl.removeById(id));
  }

  @PostMapping("/pocbsorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "poc_b_sorder");
     params.put("request", condition);

     return XfR.ok(pocBSorderServiceImpl.querys(params));
  }

}
