package com.xforceplus.ultraman.app.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.arterydocument.entity.RelationUserMarketAccount;
import com.xforceplus.ultraman.app.arterydocument.service.IRelationUserMarketAccountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-25
 */
@RestController
public class RelationUserMarketAccountController {

  @Autowired
  private IRelationUserMarketAccountService relationUserMarketAccountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param relationUserMarketAccount ${table.comment}
   * @return
   */
  @GetMapping("/relationusermarketaccounts" )
  public XfR getRelationUserMarketAccounts(XfPage page, RelationUserMarketAccount relationUserMarketAccount) {
    return XfR.ok(relationUserMarketAccountServiceImpl.page(page, Wrappers.query(relationUserMarketAccount)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/relationusermarketaccounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(relationUserMarketAccountServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param relationUserMarketAccount ${table.comment}
   * @return XfR
   */
  @PostMapping("/relationusermarketaccounts")
  public XfR save(@RequestBody RelationUserMarketAccount relationUserMarketAccount) {
     return XfR.ok(relationUserMarketAccountServiceImpl.save(relationUserMarketAccount));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param relationUserMarketAccount ${table.comment}
   * @return XfR
   */
  @PutMapping("/relationusermarketaccounts/{id}")
  public XfR putUpdate(@RequestBody RelationUserMarketAccount relationUserMarketAccount,@PathVariable Long id) {
      relationUserMarketAccount.setId(id);
      return XfR.ok(relationUserMarketAccountServiceImpl.updateById(relationUserMarketAccount));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param relationUserMarketAccount ${table.comment}
   * @return XfR
   */
  @PatchMapping("/relationusermarketaccounts/{id}")
  public XfR patchUpdate(@RequestBody RelationUserMarketAccount relationUserMarketAccount,@PathVariable Long id) {
      RelationUserMarketAccount uprelationUserMarketAccount = relationUserMarketAccountServiceImpl.getById(id);
      if(uprelationUserMarketAccount != null){
        uprelationUserMarketAccount = ObjectCopyUtils.copyProperties(relationUserMarketAccount,uprelationUserMarketAccount,true);
      }
      return XfR.ok(relationUserMarketAccountServiceImpl.updateById(uprelationUserMarketAccount));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/relationusermarketaccounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(relationUserMarketAccountServiceImpl.removeById(id));
  }

  @PostMapping("/relationusermarketaccounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "relation_user_market_account");
     params.put("request", condition);

     return XfR.ok(relationUserMarketAccountServiceImpl.querys(params));
  }

}
